/*
 * Decompiled with CFR 0.152.
 */
package weka.classifiers.rules;

import java.util.Enumeration;
import java.util.Vector;
import weka.classifiers.AbstractClassifier;
import weka.classifiers.rules.lad.binarization.Binarization;
import weka.classifiers.rules.lad.binarization.Cutpoints;
import weka.classifiers.rules.lad.core.BinaryData;
import weka.classifiers.rules.lad.core.BinaryRule;
import weka.classifiers.rules.lad.core.NumericalRule;
import weka.classifiers.rules.lad.cutpointSelection.FeatureSelection;
import weka.classifiers.rules.lad.cutpointSelection.IteratedSampling;
import weka.classifiers.rules.lad.ruleGenerators.RandomRuleGenerator;
import weka.classifiers.rules.lad.ruleGenerators.RuleGenerator;
import weka.classifiers.rules.lad.ruleManager.RuleManager;
import weka.classifiers.rules.lad.util.LADFileManager;
import weka.core.Capabilities;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.Option;
import weka.core.TechnicalInformation;
import weka.core.TechnicalInformationHandler;
import weka.core.Utils;

public class LAD
extends AbstractClassifier
implements TechnicalInformationHandler {
    private static final long serialVersionUID = -7358699627342342455L;
    private double mCutpointTolerance = 0.0;
    private double mMinimumPurity = 0.95;
    private boolean mPrintFile = false;
    private FeatureSelection mFeatureSelection = new IteratedSampling();
    private RuleGenerator mRuleGenerator = new RandomRuleGenerator();
    private Cutpoints mCutpoints = null;
    private RuleManager mRuleManager = null;
    private LADFileManager mFileManager;
    private String ERROR = "";

    @Override
    public void buildClassifier(Instances data) throws Exception {
        Binarization binarization = new Binarization(this.mCutpointTolerance);
        this.mCutpoints = binarization.findCutpoints(data);
        BinaryData trainingData = new BinaryData(data, this.mCutpoints);
        this.mFeatureSelection.checkForExceptions();
        if (this.mFeatureSelection.getSeparationLevel() > 0) {
            try {
                this.mFeatureSelection.findSelectedAtts(trainingData);
                this.mCutpoints.narrowDown(this.mFeatureSelection.getSelectedAttArray());
            }
            catch (OutOfMemoryError e) {
                this.ERROR = "\n" + LADFileManager.writeSection("Out Of Memory Error");
                this.ERROR = String.valueOf(this.ERROR) + " It was impossible to build the set covering model due the large number \n of cutpoints generated. Try increasing the cutpoint tolerance or \n allocating more memory to the JVM at startup.";
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        this.mRuleGenerator.setMinimumPurity(this.mMinimumPurity);
        this.mRuleGenerator.checkForExceptions();
        this.mRuleGenerator.generateRules(trainingData);
        this.mRuleManager = new RuleManager();
        this.mRuleManager.setAttNames(data);
        for (BinaryRule bRule : this.mRuleGenerator.getRules()) {
            this.mRuleManager.addRule(new NumericalRule(bRule, this.mCutpoints));
        }
        this.mRuleManager.adjustRulesWeight(data);
        if (this.mPrintFile) {
            this.mFileManager = new LADFileManager(data.relationName(), true);
            this.mFileManager.write(this, data.relationName());
            this.mFileManager.close();
        }
    }

    @Override
    public double[] distributionForInstance(Instance instance) throws Exception {
        double[] distribution;
        if (this.mPrintFile) {
            distribution = this.mRuleManager.distributionForInstancePSR(instance);
            this.mFileManager.restore();
            this.mFileManager.write(this.mRuleManager.getLastRepresentation());
            this.mFileManager.close();
        } else {
            distribution = this.mRuleManager.distributionForInstance(instance);
        }
        return distribution;
    }

    public Cutpoints getCutpoints() {
        return this.mCutpoints;
    }

    public RuleManager getRuleManager() {
        return this.mRuleManager;
    }

    public double getCutpointTolerance() {
        return this.mCutpointTolerance;
    }

    public void setCutpointTolerance(double cutpointTolerance) {
        this.mCutpointTolerance = cutpointTolerance;
    }

    public double getMinimumPurity() {
        return this.mMinimumPurity;
    }

    public void setMinimumPurity(double purity) {
        this.mMinimumPurity = purity;
    }

    public boolean getPrintFile() {
        return this.mPrintFile;
    }

    public void setPrintFile(boolean mPrintFile) {
        this.mPrintFile = mPrintFile;
    }

    public void setFeatureSelection(FeatureSelection featureSelection) {
        this.mFeatureSelection = featureSelection;
    }

    public FeatureSelection getFeatureSelection() {
        return this.mFeatureSelection;
    }

    public void setRuleGenerator(RuleGenerator ruleGenerator) {
        this.mRuleGenerator = ruleGenerator;
    }

    public RuleGenerator getRuleGenerator() {
        return this.mRuleGenerator;
    }

    public String globalInfo() {
        return "Implements the Logical Analysis of Data algorithm for classification.";
    }

    public String minimumPurityTipText() {
        return "Minimum purity requirement for rules. This is an upper bound on the number of points from another class that are covered by a rule (as a percentage of the total number of points covered by the rule).";
    }

    public String ruleGeneratorTipText() {
        return "The algorithm used for generating classsification rules.";
    }

    @Override
    public void setOptions(String[] options) throws Exception {
        String printFileOption;
        String ruleGeneratiorClassOption;
        String minimumPurityOption;
        String featureSelSeparationClassOption;
        String cutPointsToleranceOption = Utils.getOption('T', options);
        if (cutPointsToleranceOption.length() != 0) {
            this.setCutpointTolerance(Double.parseDouble(cutPointsToleranceOption));
        }
        if ((featureSelSeparationClassOption = Utils.getOption('F', options)).length() != 0) {
            String[] tmpOptions = Utils.splitOptions(featureSelSeparationClassOption);
            featureSelSeparationClassOption = String.valueOf(FeatureSelection.class.getPackage().getName()) + "." + tmpOptions[0];
            this.setFeatureSelection((FeatureSelection)Utils.forName(FeatureSelection.class, featureSelSeparationClassOption, tmpOptions));
            this.mFeatureSelection.setOptions(tmpOptions);
        }
        if ((minimumPurityOption = Utils.getOption('P', options)).length() != 0) {
            this.setMinimumPurity(Double.parseDouble(minimumPurityOption));
        }
        if ((ruleGeneratiorClassOption = Utils.getOption('G', options)).length() != 0) {
            String[] tmpOptions = Utils.splitOptions(ruleGeneratiorClassOption);
            ruleGeneratiorClassOption = String.valueOf(RuleGenerator.class.getPackage().getName()) + "." + tmpOptions[0];
            this.setRuleGenerator((RuleGenerator)Utils.forName(RuleGenerator.class, ruleGeneratiorClassOption, tmpOptions));
            this.mRuleGenerator.setOptions(tmpOptions);
        }
        if ((printFileOption = Utils.getOption('A', options)).length() != 0) {
            this.setPrintFile(Boolean.parseBoolean(printFileOption));
        }
        super.setOptions(options);
    }

    @Override
    public String[] getOptions() {
        Vector<String> options = new Vector<String>();
        String[] classifierOptions = super.getOptions();
        int i = 0;
        while (i < classifierOptions.length) {
            options.add(classifierOptions[i]);
            ++i;
        }
        options.add("-T");
        options.add("" + this.getCutpointTolerance());
        options.add("-F");
        options.add(this.mFeatureSelection.getClass().getSimpleName() + " " + Utils.joinOptions(this.mFeatureSelection.getOptions()));
        options.add("-P");
        options.add("" + this.getMinimumPurity());
        options.add("-G");
        options.add(this.mRuleGenerator.getClass().getSimpleName() + " " + Utils.joinOptions(this.mRuleGenerator.getOptions()));
        options.add("-A");
        options.add("" + this.getPrintFile());
        return options.toArray(new String[options.size()]);
    }

    @Override
    public Enumeration listOptions() {
        Vector<Option> newVector = new Vector<Option>();
        Enumeration classifierList = super.listOptions();
        while (classifierList.hasMoreElements()) {
            newVector.addElement((Option)classifierList.nextElement());
        }
        newVector.addElement(new Option("\tTolerance for cutpoint generation. A cutpoint will \n\tonly be generated between two values if they differ by\n\tat least this value. (Default = 0.0)\n", "T", 1, "-T <tolerance>"));
        newVector.addElement(new Option("\tFeature selection class.\n", "F", 1, "-F <feature_separation_class_simple_name> + <options>"));
        newVector.addElement(new Option("\tMinimum purity requirement for rules. This is an upper\n\tbound on the number of points from another class that\n\tare covered by a rule (as a percentage of the total number\n\tof points covered by the rule).\n", "P", 1, "-P <percentage>"));
        newVector.addElement(new Option("\tThe algorithm used for generating classsification rules.\n", "G", 1, "-G <rule_generator_class_name> + <options>"));
        Enumeration featureSelection = this.mFeatureSelection.listOptions();
        while (featureSelection.hasMoreElements()) {
            newVector.addElement((Option)featureSelection.nextElement());
        }
        Enumeration ruleGenerator = this.mRuleGenerator.listOptions();
        while (ruleGenerator.hasMoreElements()) {
            newVector.addElement((Option)ruleGenerator.nextElement());
        }
        return newVector.elements();
    }

    @Override
    public Capabilities getCapabilities() {
        Capabilities capabilities = super.getCapabilities();
        capabilities.disableAll();
        capabilities.enable(Capabilities.Capability.NUMERIC_ATTRIBUTES);
        capabilities.enable(Capabilities.Capability.BINARY_ATTRIBUTES);
        capabilities.enable(Capabilities.Capability.MISSING_VALUES);
        capabilities.enable(Capabilities.Capability.NOMINAL_CLASS);
        capabilities.enable(Capabilities.Capability.BINARY_CLASS);
        capabilities.setMinimumNumberInstances(2);
        return capabilities;
    }

    @Override
    public TechnicalInformation getTechnicalInformation() {
        TechnicalInformation result = new TechnicalInformation(TechnicalInformation.Type.INPROCEEDINGS);
        result.setValue(TechnicalInformation.Field.AUTHOR, "V.S.D. Gomes and T.O. Bonates");
        result.setValue(TechnicalInformation.Field.YEAR, "2011");
        result.setValue(TechnicalInformation.Field.TITLE, "Classificacao Supervisionada de Dados via Otimizacao e Funcoes Booleanas (in Portuguese)");
        result.setValue(TechnicalInformation.Field.BOOKTITLE, "Anais do II Workshop Tecnico-Cientifico de Computacao");
        result.setValue(TechnicalInformation.Field.ADDRESS, "Mossoro, Brazil");
        result.setValue(TechnicalInformation.Field.PAGES, "21-27");
        TechnicalInformation additional = result.add(TechnicalInformation.Type.ARTICLE);
        additional.setValue(TechnicalInformation.Field.AUTHOR, "T.O. Bonates, P.L. Hammer and A. Kogan");
        additional.setValue(TechnicalInformation.Field.YEAR, "2008");
        additional.setValue(TechnicalInformation.Field.TITLE, "Maximum Patterns in Datasets");
        additional.setValue(TechnicalInformation.Field.JOURNAL, "Discrete Applied Mathematics");
        additional.setValue(TechnicalInformation.Field.VOLUME, "156");
        additional.setValue(TechnicalInformation.Field.PAGES, "846-861");
        additional = result.add(TechnicalInformation.Type.ARTICLE);
        additional.setValue(TechnicalInformation.Field.AUTHOR, "E. Boros, P.L. Hammer, T. Ibaraki, A. Kogan, E. Mayoraz and I. Muchnik");
        additional.setValue(TechnicalInformation.Field.YEAR, "2000");
        additional.setValue(TechnicalInformation.Field.TITLE, "An Implementation of Logical Analysis of Data");
        additional.setValue(TechnicalInformation.Field.JOURNAL, "IEEE Transactions on Knowledge and Data Engineering");
        additional.setValue(TechnicalInformation.Field.VOLUME, "12");
        additional.setValue(TechnicalInformation.Field.PAGES, "292-306");
        return result;
    }

    public String toString() {
        if (this.mCutpoints == null && this.mRuleGenerator.getRules().size() == 0) {
            return "LAD: No model built yet.";
        }
        String s = String.valueOf(LADFileManager.write(this.mCutpoints)) + "\n";
        s = String.valueOf(s) + LADFileManager.write(this.mRuleManager);
        s = String.valueOf(s) + this.ERROR;
        return s;
    }

    public static void main(String[] args) throws Exception {
        LAD.runClassifier(new LAD(), args);
    }
}

